const bcrypt = require('bcrypt');

const password = 'password123';
const hash = '$2b$10$tE9Gzsf5DAhePdsmxvSt6.iQCLbu.VxY6XTesvv2QDaogummmTpuq';

bcrypt.compare(password, hash).then(result => {
  console.log('Password match:', result);
  if (!result) {
    console.log('Generating new hash for password123...');
    return bcrypt.hash(password, 10);
  }
}).then(newHash => {
  if (newHash) {
    console.log('New hash:', newHash);
  }
  process.exit(0);
});
