const express = require('express');
const { body } = require('express-validator');
const supportController = require('../controllers/supportController');
const { validate } = require('../middleware/validator');
const { authenticate } = require('../middleware/auth');

const router = express.Router();

const contactValidation = [
  body('message')
    .trim()
    .isLength({ min: 10, max: 2000 })
    .withMessage('Message must be between 10 and 2000 characters'),
];

router.post('/contact', authenticate, contactValidation, validate, supportController.contactSupport);

module.exports = router;
