const express = require('express');
const router = express.Router();
const serviceController = require('../controllers/serviceController');
const { authenticate, authorize, optionalAuth } = require('../middleware/auth');

// Public routes (browsing without login)
router.get('/', optionalAuth, serviceController.getAllServices);
router.get('/categories', serviceController.getCategories);

// Detailer-only routes (must come before :id route)
router.get('/my-services', authenticate, authorize('detailer'), serviceController.getMyServices);
router.post('/', authenticate, authorize('detailer'), serviceController.createService);
router.put('/:id', authenticate, authorize('detailer'), serviceController.updateService);
router.delete('/:id', authenticate, authorize('detailer'), serviceController.deleteService);

// Public detail route (must be last)
router.get('/:id', optionalAuth, serviceController.getServiceById);

module.exports = router;
