const express = require('express');
const router = express.Router();
const offerController = require('../controllers/offerController');
const { authenticate, authorize } = require('../middleware/auth');

// Public
router.get('/', offerController.getOffers);
router.get('/:id', offerController.getOfferById);

// Admin
router.post('/', authenticate, authorize('admin'), offerController.createOffer);
router.put('/:id', authenticate, authorize('admin'), offerController.updateOffer);
router.patch('/:id', authenticate, authorize('admin'), offerController.updateOffer);

module.exports = router;

