const express = require('express');
const router = express.Router();
const notificationController = require('../controllers/notificationController');
const { authenticate } = require('../middleware/auth');

router.get('/', authenticate, notificationController.getNotifications);
router.get('/preferences', authenticate, notificationController.getNotificationPreferences);
router.put('/preferences', authenticate, notificationController.updateNotificationPreferences);
router.post('/push-token/register', authenticate, notificationController.registerPushToken);
router.post('/push-token/unregister', authenticate, notificationController.unregisterPushToken);
router.put('/:id/read', authenticate, notificationController.markAsRead);
router.put('/read-all', authenticate, notificationController.markAllAsRead);
router.delete('/:id', authenticate, notificationController.deleteNotification);

module.exports = router;
