const express = require('express');
const router = express.Router();
const bookingController = require('../controllers/bookingController');
const { authenticate, authorize } = require('../middleware/auth');

// Client routes
router.post('/', authenticate, authorize('client'), bookingController.createBooking);
router.get('/my-bookings', authenticate, authorize('client'), bookingController.getClientBookings);
router.get('/client', authenticate, authorize('client'), bookingController.getClientBookings);

// Detailer routes
router.get('/assigned', authenticate, authorize('detailer'), bookingController.getAssignedBookings);
router.put('/:id/accept', authenticate, authorize('detailer'), bookingController.acceptBooking);
router.patch('/:id/accept', authenticate, authorize('detailer'), bookingController.acceptBooking);
router.put('/:id/reject', authenticate, authorize('detailer'), bookingController.rejectBooking);
router.patch('/:id/reject', authenticate, authorize('detailer'), bookingController.rejectBooking);
router.put('/:id/start', authenticate, authorize('detailer'), bookingController.startBooking);
router.patch('/:id/start', authenticate, authorize('detailer'), bookingController.startBooking);
router.put('/:id/complete', authenticate, authorize('detailer'), bookingController.completeBooking);
router.patch('/:id/complete', authenticate, authorize('detailer'), bookingController.completeBooking);

// Common routes
router.get('/:id', authenticate, bookingController.getBookingById);
router.put('/:id/cancel', authenticate, bookingController.cancelBooking);
router.patch('/:id/cancel', authenticate, bookingController.cancelBooking);

module.exports = router;
