const db = require('../config/database');
const { asyncHandler } = require('../middleware/errorHandler');

/**
 * @desc    Submit support message
 * @route   POST /api/v1/support/contact
 * @access  Private
 */
exports.contactSupport = asyncHandler(async (req, res) => {
  const userId = req.user?.id;
  const role = req.user?.role || 'unknown';
  const message = String(req.body?.message || '').trim();

  if (!message) {
    return res.status(400).json({
      success: false,
      message: 'Message is required',
    });
  }

  if (message.length < 10) {
    return res.status(400).json({
      success: false,
      message: 'Please provide more details in your message',
    });
  }

  await db.query(
    `INSERT INTO support_messages (user_id, role, message, status)
     VALUES (?, ?, ?, 'open')`,
    [userId, role, message]
  );

  res.status(201).json({
    success: true,
    message: 'Your support message has been received',
  });
});
