const db = require('../config/database');
const { asyncHandler } = require('../middleware/errorHandler');

/**
 * @desc    Get public settings for the app
 * @route   GET /api/v1/settings/public
 * @access  Public
 */
exports.getPublicSettings = asyncHandler(async (req, res) => {
  const [rows] = await db.query(
    'SELECT key_name, key_value, description FROM settings WHERE is_public = 1 ORDER BY key_name ASC'
  );

  // return both as array and as a convenience map
  const map = rows.reduce((acc, r) => {
    acc[r.key_name] = r.key_value;
    return acc;
  }, {});

  res.json({
    success: true,
    data: rows,
    map,
  });
});

