const jwt = require('jsonwebtoken');

/**
 * Generate JWT access token
 */
exports.generateToken = (payload) => {
  return jwt.sign(payload, process.env.JWT_SECRET, {
    expiresIn: process.env.JWT_EXPIRES_IN || '7d'
  });
};

/**
 * Generate JWT refresh token
 */
exports.generateRefreshToken = (payload) => {
  return jwt.sign(payload, process.env.JWT_REFRESH_SECRET, {
    expiresIn: process.env.JWT_REFRESH_EXPIRES_IN || '30d'
  });
};

/**
 * Generate password reset token
 */
exports.generateResetToken = (payload) => {
  return jwt.sign(payload, process.env.JWT_RESET_SECRET || process.env.JWT_SECRET, {
    expiresIn: process.env.JWT_RESET_EXPIRES_IN || '15m'
  });
};

/**
 * Verify JWT token
 */
exports.verifyToken = (token) => {
  try {
    return jwt.verify(token, process.env.JWT_SECRET);
  } catch (error) {
    throw new Error('Invalid or expired token');
  }
};

/**
 * Verify refresh token
 */
exports.verifyRefreshToken = (token) => {
  try {
    return jwt.verify(token, process.env.JWT_REFRESH_SECRET);
  } catch (error) {
    throw new Error('Invalid or expired refresh token');
  }
};

/**
 * Verify password reset token
 */
exports.verifyResetToken = (token) => {
  try {
    return jwt.verify(token, process.env.JWT_RESET_SECRET || process.env.JWT_SECRET);
  } catch (error) {
    throw new Error('Invalid or expired reset token');
  }
};

/**
 * Decode token without verification
 */
exports.decodeToken = (token) => {
  return jwt.decode(token);
};
