const mysql = require('mysql2/promise');

const pool = mysql.createPool({
  host: process.env.DB_HOST || 'localhost',
  port: process.env.DB_PORT || 3306,
  user: process.env.DB_USER || 'root',
  password: process.env.DB_PASSWORD || '',
  database: process.env.DB_NAME || 'simbi_services',
  waitForConnections: true,
  connectionLimit: 20,
  queueLimit: 0,
  enableKeepAlive: true,
  keepAliveInitialDelay: 0,
  decimalNumbers: true,
  authPlugins: {
    mysql_native_password: () => () => 'password'
  }
});

// Test connection
pool.getConnection()
  .then(connection => {
    console.log('Database pool created successfully');
    connection.release();
  })
  .catch(err => {
    console.error('Error creating database pool:', err.message);
  });

module.exports = pool;
