# Simbi Services API Documentation

## Base URL
```
http://localhost:5000/api/v1
```

## Authentication

All protected endpoints require a JWT token in the Authorization header:
```
Authorization: Bearer <your_token>
```

---

## Authentication Endpoints

### Register User
**POST** `/auth/register`

**Body:**
```json
{
  "email": "user@example.com",
  "password": "password123",
  "role": "client", // or "detailer"
  "first_name": "John", // for client
  "last_name": "Doe", // for client
  "business_name": "Clean Cars", // for detailer
  "owner_name": "John Doe", // for detailer
  "phone": "+256700000000",
  "address": "Kampala",
  "city": "Kampala",
  "latitude": 0.3476,
  "longitude": 32.5825
}
```

### Login
**POST** `/auth/login`

**Body:**
```json
{
  "email": "user@example.com",
  "password": "password123"
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "user": {
      "id": 1,
      "email": "user@example.com",
      "role": "client"
    },
    "accessToken": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
    "refreshToken": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9..."
  }
}
```

### Get Current User
**GET** `/auth/me`
- **Auth:** Required

---

## Services Endpoints

### Get All Services (Public)
**GET** `/services`

**Query Parameters:**
- `category` - Filter by category ID
- `city` - Filter by city
- `min_price` - Minimum price
- `max_price` - Maximum price
- `detailer_id` - Filter by detailer
- `search` - Search term
- `latitude` - User latitude for distance calculation
- `longitude` - User longitude
- `radius` - Search radius in km (default: 50)
- `page` - Page number (default: 1)
- `limit` - Items per page (default: 20)

### Get Service by ID
**GET** `/services/:id`

### Create Service (Detailer only)
**POST** `/services`
- **Auth:** Required (Detailer)

**Body:**
```json
{
  "category_id": 1,
  "name": "Basic Car Wash",
  "description": "Exterior wash and vacuum",
  "price": 50000,
  "duration_minutes": 60
}
```

### Update Service
**PUT** `/services/:id`
- **Auth:** Required (Detailer)

### Delete Service
**DELETE** `/services/:id`
- **Auth:** Required (Detailer)

---

## Detailers Endpoints

### Get All Detailers (Public)
**GET** `/detailers`

**Query Parameters:**
- `city` - Filter by city
- `min_rating` - Minimum rating
- `verified_only` - Show only verified detailers
- `latitude`, `longitude`, `radius` - Location-based search

### Get Detailer by ID
**GET** `/detailers/:id`

### Update Detailer Profile
**PUT** `/detailers/profile`
- **Auth:** Required (Detailer)
- **Content-Type:** multipart/form-data

### Update Availability
**PUT** `/detailers/availability`
- **Auth:** Required (Detailer)

**Body:**
```json
{
  "is_available": true
}
```

---

## Bookings Endpoints

### Create Booking (Client only)
**POST** `/bookings`
- **Auth:** Required (Client)

**Body:**
```json
{
  "service_id": 1,
  "booking_date": "2026-02-10",
  "booking_time": "10:00:00",
  "vehicle_type": "Sedan",
  "vehicle_model": "Toyota Camry",
  "vehicle_plate": "UAH 123X",
  "location_address": "Kampala Road",
  "location_latitude": 0.3476,
  "location_longitude": 32.5825,
  "notes": "Please call when arriving"
}
```

### Get Client Bookings
**GET** `/bookings/my-bookings`
- **Auth:** Required (Client)

### Get Assigned Bookings (Detailer)
**GET** `/bookings/assigned`
- **Auth:** Required (Detailer)

### Get Booking by ID
**GET** `/bookings/:id`
- **Auth:** Required

### Complete Booking (Detailer)
**PUT** `/bookings/:id/complete`
- **Auth:** Required (Detailer)

### Cancel Booking
**PUT** `/bookings/:id/cancel`
- **Auth:** Required

**Body:**
```json
{
  "cancellation_reason": "Change of plans"
}
```

---

## Payments Endpoints

### Upload Payment Proof
**POST** `/payments/upload-proof`
- **Auth:** Required (Client)
- **Content-Type:** multipart/form-data

**Form Data:**
- `booking_id` - Booking ID
- `payment_method` - bank_transfer | mobile_money | cash
- `payment_proof` - File (image/pdf)
- `transaction_id` - Optional
- `payment_date` - Optional
- `notes` - Optional

### Get Payment Details
**GET** `/payments/:bookingId`
- **Auth:** Required

---

## Reviews Endpoints

### Create Review
**POST** `/reviews`
- **Auth:** Required (Client)

**Body:**
```json
{
  "booking_id": 1,
  "rating": 5,
  "review_text": "Excellent service!"
}
```

### Get Detailer Reviews (Public)
**GET** `/reviews/detailer/:detailerId`

---

## Notifications Endpoints

### Get Notifications
**GET** `/notifications`
- **Auth:** Required

### Mark as Read
**PUT** `/notifications/:id/read`
- **Auth:** Required

### Mark All as Read
**PUT** `/notifications/read-all`
- **Auth:** Required

---

## Status Codes

- `200` - OK
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `500` - Internal Server Error

## Error Response Format

```json
{
  "success": false,
  "message": "Error description",
  "errors": [
    {
      "field": "email",
      "message": "Email is required"
    }
  ]
}
```
